"""Tests the RewardModel class."""
import gym

from offline_rl.rewards.reward_model import RewardModel


class ExampleRewardModel(RewardModel):
    def reward(self, *args):
        del args
        return 0

    @property
    def observation_space(self):
        return gym.spaces.Discrete(2)

    @property
    def action_space(self):
        return gym.spaces.Discrete(2)


class TestRewardModel:
    def test_typing(self):
        # Check that a subclass can be instantiated without error.
        try:
            ExampleRewardModel()
        except TypeError:
            assert False, "Improper subclass instantiation."
