#!/usr/bin/env bash

### GSM8k

# GSM8k zero-shot
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_8b_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_70b_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_3_8b_instruct_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_13b_instruct_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_20b_code_instruct_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_34b_code_instruct_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl

# GSM8k 8-shot PAL/SC prompt
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_8b_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_70b_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_3_8b_instruct_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_13b_instruct_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_20b_code_instruct_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_34b_code_instruct_gsm8k_pal_8_shot.yml examples/prompt_library/exp/gsm8k/general.pdl

# GSM8k 5-shot optimized
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_8b_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/llama_70b_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_3_8b_instruct_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_13b_instruct_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_20b_code_instruct_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/granite_34b_code_instruct_gsm8k_opt.yml examples/prompt_library/exp/gsm8k/general.pdl

### FEVER
# FEVER zeroshot
python -m pdl.optimize.optimize --config exp_configs/fever/llama_8b_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/llama_70b_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_3_8b_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_13b_instruct_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_20b_code_instruct_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_34b_code_instruct_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl

# FEVER 5-shot optimized
python -m pdl.optimize.optimize --config exp_configs/fever/llama_8b_fever_opt.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/llama_70b_fever_opt.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_3_8b_instruct_fever_opt.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_13b_instruct_fever_opt.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_20b_code_instruct_fever_opt.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/fever/granite_34b_code_instruct_fever_opt.yml examples/prompt_library/exp/fever/general.pdl

### MBPP
# MBPP zeroshot
python -m pdl.optimize.optimize --config exp_configs/evalplus/llama_8b_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/llama_70b_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_3_8b_instruct_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_13b_instruct_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_20b_code_instruct_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_34b_code_instruct_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl

# MBPP 5-shot optimized
python -m pdl.optimize.optimize --config exp_configs/evalplus/llama_8b_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/llama_70b_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_3_8b_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_13b_instruct_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_20b_code_instruct_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/granite_34b_code_instruct_evalplus_opt.yml examples/prompt_library/exp/evalplus/general.pdl

# GSM-Hard

python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_3_8b_instruct_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/llama_8b_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_13b_instruct_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_20b_code_instruct_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_34b_code_instruct_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/llama_70b_gsmhard_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl

python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_3_8b_instruct_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/llama_8b_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_13b_instruct_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_20b_code_instruct_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/granite_34b_code_instruct_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/llama_70b_gsmhard_opt.yml examples/prompt_library/exp/gsm8k/general.pdl

# GPT4o-mini
python -m pdl.optimize.optimize --config exp_configs/fever/gpt4o_fever_zero_shot.yml examples/prompt_library/exp/fever/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/gpt4o_gsm8k_zero_shot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/gpt4o_gsmhard_zeroshot.yml examples/prompt_library/exp/gsm8k/general.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/gpt4o_evalplus_zero_shot.yml examples/prompt_library/exp/evalplus/general.pdl

python -m pdl.optimize.optimize --config exp_configs/fever/gpt4o_mini_test.yml examples/prompt_library/exp/fever/gpt4_general_1biwjkln.pdl
python -m pdl.optimize.optimize --config exp_configs/gsm8k/gpt4o_mini_test_gsm8k.yml examples/prompt_library/exp/gsm8k/gpt4o_mini_general_gsm8k_gfde5gbc_0qk01vfk.pdl
python -m pdl.optimize.optimize --config exp_configs/gsmhard/gpt4o_mini_test_gsmhard.yml examples/prompt_library/exp/gsm8k/gpt4o_mini_general_gsmhard_pqarx1ts_9xfwqqxh.pdl
python -m pdl.optimize.optimize --config exp_configs/evalplus/gpt4o_mini_test.yml examples/prompt_library/exp/evalplus/gpt4o_mini_general_evalplus_fhyvu2z6_hk7eldp1.pdl