import threading
from collections import Counter

# Global thread-safe counter for token usage
usage_counter = Counter()
usage_lock = threading.Lock()


def get_usage_stats():
    with usage_lock:
        return dict(usage_counter)  # Return a copy to avoid race conditions

def reset_usage_stats():
    with usage_lock:
        usage_counter.clear()
