# Generalized Decision Transformer for Offline Hindsight Information Matching

## Installation

Experiments require MuJoCo.
Follow the instructions in the [mujoco-py repo](https://github.com/openai/mujoco-py) to install.
Then, dependencies can be installed with the following command:

```
conda env create -f conda_env.yml
```

## Downloading datasets

Datasets are stored in the `data` directory.
Install the [D4RL repo](https://github.com/rail-berkeley/d4rl), following the instructions there.
Then, run the following script in order to download the datasets and save them in our format:

```
python download_d4rl_datasets.py
```

## Run experiments

Run train.py to train Categorical DT:
```
python train.py --env halfcheetah --dataset medium-expert --gpu 0 --seed 0 --dist_dim 30 --n_bins 31 --distributions 'categorical' --condition 'reward' --save_model True

python train.py --env halfcheetah --dataset medium-expert --gpu 0 --seed 0 --dist_dim 30 --n_bins 31 --distributions 'categorical' --condition 'xvel' --save_model True
```

Run eval.py to eval CDT using saved weights:
```
python eval.py --env halfcheetah --dataset medium-expert --gpu 0 --seed 0 --dist_dim 30 --n_bins 31 --distributions 'categorical' --condition 'reward' --eval_target 'fix' --save_rollout True
```


For Bi-directional DT, run train_tf.py & eval_tf.py
```
python train_tf.py --env halfcheetah --dataset medium-expert --gpu 0 --seed 0 --dist_dim 30 --n_bins 31 --z_dim 16 --save_model True
python eval_tf.py --env halfcheetah --dataset medium-expert --gpu 0 --seed 0 --dist_dim 30 --n_bins 31 --eval_target 'fix' --z_dim 16 --save_rollout True
```

## Reference
- [Decision Transformer](https://github.com/kzl/decision-transformer)
