# Objective Evaluation of Deep Visual Interpretations on Time Series Data

This readme serves as a tutorial for evaluating the UCR dataset GunPointAgeSpan. All other UCR datasets can be evaluated by adapting files in the folder `ford` while tool tracking is located in its accordingly named folder.

## Train model and Load data

1. To train models, use the file `train.py` in the directory `gun_point`

2. In `train.py`, the function `read_dataset_ts`  loads the data. It is specified for UCR datasets with data files `.ts`.

3. The function `read_dataset_ts` optionally performs zero-mean normalization.

4. You can create an extra directory to use [hydra-core](https://hydra.cc/) to call models and data setup from the directory `conf`

## Visual Interpretation 

Visual interpretation methods are based on [Captum](https://captum.ai/)

1. Install [Captum](https://captum.ai/): Either use the `requirement.txt` get it from [Captum github](https://github.com/pytorch/captum).

2. All 9 methods (Backpropagation and Perturbation based) are located in the file `visualize_mechanism/visual_utils.py`. 

3. To execute them on models and data, use the file `gun_point/evaluation/visual_interpretability.py`.

4. `gun_point/evaluation/visual_interpretability.py` loads the test set (in `load_data_and_models()`). In the function `get_saliencymaps`, 9 methods are called to produce the interpretation. You can change parameters here, compare `visualize_mechanism/visual_utils.py`.

5. The function `save_saliencymaps()` stores saliency maps generated by `get_saliencymaps()`.


## Evaluation metrics 

1. The metrics are located under the directory `metrics`. Mainly, `temporal_importance.py` is used for **Temporal Importance/Unimportance**. `temporal_sequence_eval.py` is for the metric **Temporal Swap and Mean time points**. `sensivitiy_max.py` is for **Sensitivity Max** and `sanity_check.py` contains the code for **Sanity Check**. Inside the `pointing_game.py`, there are functions `pointing_game` and `iosaliency_regions`. `iosaliency_regions` is for **Intersection over the salient region** used in Localization. `precision_recall_4_ts.py` is also for Localization, which calculates precision and recall for time series. `robustness.py` is used to evaluate **Robustness**, and finally, `class_sensitivity.py` is used to evaluate **Class Sensitivity**.

2. To run the codes, see files in `gun_point/evaluation/`, e.g.,  `temporal_saliency_importance.py`.

