"""
Explanation Sensitivity Measures
Class Sensitivity
References: https://openaccess.thecvf.com/content_CVPR_2020/papers/Rebuffi_There_and_Back_Again_Revisiting_Backpropagation_Saliency_Methods_CVPR_2020_paper.pdf
also from: https://export.arxiv.org/abs/2012.15616
"""

## -------------------
## --- Third-Party ---
## -------------------
import os
import sys
sys.path.append('../../')
fileDir = os.path.dirname(os.path.abspath(__file__))
parentDir = os.path.dirname(fileDir)
sys.path.append(parentDir)
import argparse
import torch as t

## -----------
## --- Own ---
## -----------
from visual_interpretability import load_data_and_models
from gun_point.evaluation.class_sensitivity_eval import class_sensitivity_evaluation

def parse_arguments(argv):
    parser = argparse.ArgumentParser()

    # parser.add_argument("--Root_Dir", type=str, default='../')
    parser.add_argument("--Dataset_name", type=str, default='tool_tracking_Cluster')
    parser.add_argument("--Dataset_name_save", type=str, default='tool_tracking_Cluster')
    parser.add_argument("--Experiments", nargs='+', default='experiment_0')
    parser.add_argument("--DLModel", type=str, default='FCN_withoutFC')

    parser.add_argument("--Use_tsr", action="store_true", default=True)
    parser.add_argument("--Save_scores_path", type=str, default='class_sensitivity_correlation.npy')

    parser.add_argument("--Data_path", type=str, default='data/tool_tracking_data')
    parser.add_argument("--Detection", action="store_true", default=False)
    parser.add_argument("--Znorm", action="store_true", default=True)
    parser.add_argument("--One_matrix", action="store_true", default=True)
    parser.add_argument("--Sparse_labels", action="store_true", default=True)
    parser.add_argument("--Window_length", type=float, default=0.2)

    return parser.parse_args()

if __name__ == "__main__":
    args = parse_arguments(sys.argv[1:])

    print("Load Data and Model")
    testsets, models, model_softmaxs, saliency_constructor_gcs, saliency_constructors = load_data_and_models(
        args=args
    )

    dl_selected_model = args.DLModel
    device = t.device('cuda' if t.cuda.is_available() else 'cpu')
    if dl_selected_model not in ['LSTM']:
        # methods = ["lrp_epsilon"]
        # methods = ["grads",
        #            "smoothgrads",
        #            "integrated_gradients",
        #            "lrp_epsilon",
        #            "lrp_gamma",
        #            "gradCAM",
        #            "g_gradCAM",
        #            "gbp",
        #            "lime",
        #            "kernelShap"]
        methods = ["grads",
                   "smoothgrads",
                   "integrated_gradients",
                   "lrp_epsilon",
                   # "lrp_gamma",
                   "gradCAM",
                   "g_gradCAM",
                   "gbp"]
    else:
        # methods = ["grads",
        #            "smoothgrads",
        #            "integrated_gradients",
        #            "lrp_epsilon",
        #            "lime",
        #            "kernelShap"]
        methods = ["grads",
                   "smoothgrads",
                   "integrated_gradients",
                   "lrp_epsilon"]

    save_scores_path = args.Save_scores_path
    use_tsr = args.Use_tsr
    correlation = class_sensitivity_evaluation(args=args,
                                               model=models[0],
                                               dataset=testsets[0],
                                               vis_methods=methods,
                                               use_tsr=use_tsr,
                                               save_scores_path=save_scores_path)
