"""
Explanation Sensitivity Measures
Sensitivity-Max
References: https://arxiv.org/pdf/1901.09392.pdf
also from Captum: https://captum.ai/api/metrics.html

"""
## -------------------
## --- Third-Party ---
## -------------------
import os
import sys
sys.path.append('../../')
fileDir = os.path.dirname(os.path.abspath(__file__))
parentDir = os.path.dirname(fileDir)
sys.path.append(parentDir)
import argparse
import torch as t

## -----------
## --- Own ---
## -----------
from visual_interpretability import load_data_and_models
from gun_point.evaluation.sensitivity_max_eval import sensitivity_test_eval


def parse_arguments(argv):
    parser = argparse.ArgumentParser()

    # parser.add_argument("--Root_Dir", type=str, default='../')
    parser.add_argument("--Dataset_name", type=str, default='tool_tracking_Cluster')
    parser.add_argument("--Dataset_name_save", type=str, default='tool_tracking_Cluster')
    parser.add_argument("--Experiments", nargs='+', default='experiment_0')
    parser.add_argument("--DLModel", type=str, default='FCN_withoutFC')

    parser.add_argument("--Perturb_radius", type=float, default=0.05)
    parser.add_argument("--N_perturb_samples", type=int, default=10)
    parser.add_argument("--Save_scores_path", type=str, default='sensitivity_max_scores.npy')

    parser.add_argument("--Data_path", type=str, default='data/tool_tracking_data')
    parser.add_argument("--Detection", action="store_true", default=False)
    parser.add_argument("--Znorm", action="store_true", default=True)
    parser.add_argument("--One_matrix", action="store_true", default=True)
    parser.add_argument("--Sparse_labels", action="store_true", default=True)
    parser.add_argument("--Window_length", type=float, default=0.2)

    return parser.parse_args()

if __name__ == "__main__":
    args = parse_arguments(sys.argv[1:])

    print("Load Data and Model")
    testsets, models, model_softmaxs, saliency_constructor_gcs, saliency_constructors = load_data_and_models(
        args=args
    )

    dl_selected_model = args.DLModel
    device = t.device('cuda' if t.cuda.is_available() else 'cpu')
    if dl_selected_model not in ['LSTM', 'MLP']:
        # methods = ["lrp_epsilon"]
        # methods = ["grads",
        #            "smoothgrads",
        #            "integrated_gradients",
        #            "lrp_epsilon",
        #            "lrp_gamma",
        #            "gradCAM",
        #            "g_gradCAM",
        #            "gbp",
        #            "lime",
        #            "kernelShap"]
        methods = ["grads",
                   "smoothgrads",
                   "integrated_gradients",
                   "lrp_epsilon",
                   # "lrp_gamma",
                   "gradCAM",
                   "g_gradCAM",
                   "gbp"]
    else:
        # methods = ["grads",
        #            "smoothgrads",
        #            "integrated_gradients",
        #            "lrp_epsilon",
        #            "lime",
        #            "kernelShap"]
        methods = ["grads",
                   "smoothgrads",
                   "integrated_gradients",
                   "lrp_epsilon"]

    save_scores_path = args.Save_scores_path
    mean_scores, std_scores = sensitivity_test_eval(args=args,
                                                    model=models[0],
                                                    dataset=testsets[0],
                                                    vis_methods=methods,
                                                    save_scores_path=save_scores_path)