
class EarlyStoppingCallback:
    """
    Early stops the training if test loss doesn't improve after a given Patience
    """
    def __init__(self, patience):
        self.patience = patience
        self.count = 0
        self.best_loss = None
        self.early_stop = False

    def step(self, current_loss):
        val = current_loss
        if self.best_loss is None:
            self.best_loss = val
        elif current_loss > self.best_loss:
            self.count += 1
        else:
            self.best_loss = current_loss
            self.count = 0

    def should_stop(self):
        if self.count >= self.patience:
            self.early_stop = True
        else:
            self.early_stop = False