"""
This file runs the main training/val loop
"""
import os
import json
import sys
import pprint

sys.path.append(".")
sys.path.append("..")
sys.path.append("../models/eg3d")

# def set_env(depth: int):
#     # Add project root to sys.path
#     current_file_path = os.path.abspath(__file__)
#     project_root_path = os.path.dirname(current_file_path)
#     for _ in range(depth):
#         project_root_path = os.path.dirname(project_root_path)
#     if project_root_path not in sys.path:
#         sys.path.append(project_root_path)
#         print(f"Added {project_root_path} to sys.path")
# set_env(2)

from mapper.options.train_options import TrainOptions
from mapper.mapper_training.coach import Coach

import tensorflow as tf


config = tf.compat.v1.ConfigProto()
config.gpu_options.allow_growth = True
session = tf.compat.v1.Session(config=config)
tf.compat.v1.keras.backend.set_session(session)


def main(opts):
	if os.path.exists(opts.exp_dir):
		raise Exception('Oops... {} already exists'.format(opts.exp_dir))
	os.makedirs(opts.exp_dir, exist_ok=True)

	opts_dict = vars(opts)
	pprint.pprint(opts_dict)
	with open(os.path.join(opts.exp_dir, 'opt.json'), 'w') as f:
		json.dump(opts_dict, f, indent=4, sort_keys=True)

	coach = Coach(opts)
	coach.train()


if __name__ == '__main__':
	opts = TrainOptions().parse()
	if opts.batch_size != 1 or opts.test_batch_size != 1:
		raise Exception('This version only supports batch size and test batch size to be 1.')
	main(opts)
