from abc import ABC
from abc import abstractmethod
from utils import log
import json
from server.policy import LLMPolicy


class Agent(ABC):
    
    def __init__(self, profile) -> None:
        
        self.logger = log.get_loguru()
        self.profile = profile
        
    @abstractmethod
    def run(self, *args, **kwargs):
        return NotImplemented

    @abstractmethod
    def finalize(self, *args, **kwargs):
        return NotImplemented


class ToolAgent(Agent):
    
    def __init__(self, profile) -> None:
        super().__init__(profile)
        self.policy = LLMPolicy(profile)
