from abc import ABC, abstractmethod
from enum import Enum
from utils import log


class FiniteState(ABC):
    
    def __init__(self, profile):
        
        self.profile = profile
        self.logger = log.get_loguru()
            
    @abstractmethod
    def initialize_state(self):
        pass

    @abstractmethod
    def state_transition(self, *args, **kwargs):
        pass

class TaskStateValue(Enum):
    
    UnSolved = 0
    Running = 1 # NOT USED
    PartiallySolved = 2
    Solved = 3
    Stop = 4
    Error = 5

class ActionStateValue(Enum):
    
    TaskInit = 0
    TaskPlanning = 1
    ToolSelection = 2
    ToolExecution = 3
    ToolReflection = 4
    TaskReflection = 5