import yaml, os, json
from utils import api_util, log
import requests
import time
from openai import OpenAI
import random
from datetime import datetime


class LeetcodeEnv:

    def __init__(self, profile):
        
        self.logger = log.get_loguru()

        parameter = profile.load_env()['leetcode']
        self.timeout = parameter['timeout']
        self.url = parameter['url']
        self.toolbench_key = parameter['toolbench_key']

        self.debug = True
        
    @property
    def name(self):
        return "leetcode"

    def __call__(self, category_name, tool_name, api_name, func_input, fmt=False, check=False):
        
        if self.debug:
            start_time = time.perf_counter()
        
        try:
            call_response = self._call(category_name, tool_name, api_name, func_input)
        except Exception as e:
            self.logger.info("Exception {}".format(e))
            return False, "Exception {}".format(e)
        
        if self.debug:
            end_time = time.perf_counter()
            elapsed_time = end_time - start_time
            self.logger.info("call spend time {}".format(elapsed_time))
        
        req_status = False
        if call_response.status_code == 200:
            
            response = call_response.json()
            if check:
                if response['error']:
                    self.logger.info("Rapid API {} {} {}. Call Error {}...".format(category_name, tool_name, api_name, response['error']))
                    req_status = False
                else:
                    req_status = True
            else:
                req_status = True
            
            return req_status, response
        else:
            return False, "Run Rapid Env Response Status={}".format(response.status_code)
    
    def _call(self, category_name, tool_name, api_name, func_input):
        
        payload = {
            "category": category_name,
            "tool_name": tool_name, 
            "api_name": api_name,
            "tool_input": func_input,
            "platform": "leetcode",
            "toolbench_key": self.toolbench_key,
        }
        
        headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
        }
        return requests.post(self.url, json=payload, headers=headers, timeout=self.timeout)

    def check_param(self, category_name, tool_name, api_name, func_input, fmt=False):
        
        if self.debug:
            start_time = time.perf_counter()

        try:
            call_response = self._call_check_param(category_name, tool_name, api_name, func_input)
        except Exception as e:
            self.logger.info("Exception {}".format(e))
            return False, {"error": "Call: {}".format(e), "response": ""}
        
        if self.debug:
            end_time = time.perf_counter()
            elapsed_time = end_time - start_time
            self.logger.info("check spend time {}".format(elapsed_time))

        if call_response.status_code == 200:
            response = call_response.json()
            if response['error']:
                return False, response
            else:
                return True, response
        else:
            return False, {"error": "Status: {}".format(call_response.status_code), "response": ""}

    def _call_check_param(self, category_name, tool_name, api_name, func_input):
        
        payload = {
            "category": category_name,
            "tool_name": tool_name, 
            "api_name": api_name,
            "tool_input": func_input,
            "check_parameters": True,
            "check_parallel": True,
            "platform": "leetcode",
            "toolbench_key": self.toolbench_key,
        }
        
        headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json',
        }
        return requests.post(self.url, json=payload, headers=headers, timeout=self.timeout)