import yaml, os, json
from utils import api_util, log
import requests
import time
from openai import OpenAI
import random
from datetime import datetime


class PseudoEnv:

    def __init__(self, profile):
        
        self.logger = log.get_loguru()

        parameter_format_file = profile.load_env()['pseudo']["parameter_format_file"]
        
        self.key2parameter = {}
        self._load_parameter_format(parameter_format_file)
        self.debug = False

    def build_key(self, category_name, tool_name, api_name):
        return "{}##{}##{}".format(category_name, tool_name, api_name)

    def _load_parameter_format(self, parameter_format_file):

        for line in open(parameter_format_file).readlines():
            json_item = json.loads(line)
            for api in json_item['api_list']:
                _key = self.build_key(api['category_name'], api['tool_name'], api['api_info']['api_name'])
                self.key2parameter[_key] = api['api_info']['api_param']

    @property
    def name(self):
        return "pseudo"

    def __call__(self, category_name, tool_name, api_name, func_input, fmt=False, check=False):
        return True, {"error": "", "response": "call success, return the good results"}

    def _type_check(self, data_key, data_value, data_type, data_info):
        
        if data_type == "integer":
            if not isinstance(data_value, int):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
        elif data_type == "string":
            if not isinstance(data_value, str):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
        elif data_type == 'boolean':
            if not isinstance(data_value, bool):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
        elif data_type == 'float':
            if isinstance(data_value, int):
                return
            if not isinstance(data_value, float):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
        elif data_type == 'array':
            if not isinstance(data_value, list):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
            if "items" in data_info:
                for d in data_value:
                    if data_info['items']['type'] == 'float':
                        if not isinstance(d, float):
                            raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python items type {data_info['items']['type']}, but given {type(d)}")
                    elif data_info['items']['type'] == 'int':
                        if not isinstance(d, int):
                            raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python items type {data_info['items']['type']}, but given {type(d)}")

        elif data_type == 'dict':
            if not isinstance(data_value, dict):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
        elif data_type == 'tuple':
            if not isinstance(data_value, tuple):
                raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python type {data_type}, but given {type(data_value)}")
            if "items" in data_info:
                for d in data_value:
                    if data_info['items']['type'] == 'float':
                        if not isinstance(d, float):
                            raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python items type {data_info['items']['type']}, but given {type(d)}")
                    elif data_info['items']['type'] == 'int':
                        if not isinstance(d, int):
                            raise Exception(f"The parameter `{data_key}` value {data_value} must match the required python items type {data_info['items']['type']}, but given {type(d)}")
        # else:
        #     import pdb; pdb.set_trace()

    def check_param(self, category_name, tool_name, api_name, func_input, fmt=False):
        
        _key = self.build_key(category_name, tool_name, api_name)
        parameters = self.key2parameter[_key]

        for parameter_key in parameters['required']:
            if parameter_key not in func_input:
                return False, "The parameter {} is required and must be provided for {}.".format(parameter_key, api_name)
        
        try:
            for parameter_name, parameter in parameters["properties"].items():
                if parameter_name in func_input:
                    self._type_check(parameter_name, func_input[parameter_name], parameter['type'], parameter)
        except Exception as e:
            return False, e

        return True, "parameter check sucess."       
