from .asyncio_queue import AsyncQueue
from .threading_queue import ThreadingQueue


class InstanceQueue:
    
    def __init__(self, concurrent, asyncio=True):
        
        if asyncio:
            self.runner = AsyncQueue(concurrent)
        else:
            self.runner = ThreadingQueue(concurrent)
        
    def run(self, agent, message_generator):
        self.runner.run(agent, message_generator)

    def run_noparam(self, executor):
        self.runner.run_noparam(executor)

    def run_param(self, executor, message_generator):
        self.runner.run_param(executor, message_generator)

class ActionQueue:
    
    def __init__(self, concurrent=5):
        # self.runner = AsyncQueue(concurrent)
        self.runner = ThreadingQueue(concurrent)
    
    def run(self, in_funcs, func_args):
        # return self.runner.run_in_executor(in_funcs, func_args)
        return self.runner.run_in_executor(in_funcs, func_args)
