from .generator.single import SingleGenerator
from .generator.single_for_java import SingleGenerator_forjava
from .generator.parallel import ParallelGenerator
from .generator.multiple import MultipleGenerator
from .generator.multiple_parallel import MultipleParallelGenerator
from .generator.format import FormatGenerator
from pipeline.generator.base import Action
from server.policy import LLMPolicy
from env.leetcode_env import LeetcodeEnv
from utils import log
import json
import threading
import random
import uuid
import os


class LeetcodeGenerator:

    def __init__(self, profile, action):
        
        self.logger = log.get_loguru()
        
        self.action = action
        self.policy = LLMPolicy(profile)
        self.leetcode_env = LeetcodeEnv(profile)
                
        if self.action == Action.Single:
            self.generator = SingleGenerator(profile, self.leetcode_env, self.policy)
        elif self.action == Action.Single_java:
            self.generator = SingleGenerator_forjava(profile, self.leetcode_env, self.policy)
        elif self.action == Action.Parallel:
            self.generator = ParallelGenerator(profile, self.leetcode_env, self.policy)
        elif self.action == Action.Multiple:
            self.generator = MultipleGenerator(profile, self.leetcode_env, self.policy)
        elif self.action == Action.MultipleParallel:
            self.generator = MultipleParallelGenerator(profile, self.leetcode_env, self.policy)
        elif self.action == Action.Format:
            self.generator = FormatGenerator(profile, self.leetcode_env, self.policy)
        else:
            raise Exception("Not support this action {}".format(self.action))
        
        self.leetcode_check_file = profile.load_input()["leetcode_check"]
        self.id2tool = {}
        self.id2category = {}
        self.id2api = {}
        self._load_candidate_api()
        
    def _load_candidate_api(self):
        
        tool_dict = {}
        category_dict = {}
        for line in open(self.leetcode_check_file).readlines():
            json_item = json.loads(line)
            self.id2api[json_item['api_id']] = json_item['api_info']

            if json_item['api_info']['tool_name'] not in tool_dict:
                tool_dict[json_item['api_info']['tool_name']] = [json_item['api_id']]
            else:
                tool_dict[json_item['api_info']['tool_name']].append(json_item['api_id'])
            
            if json_item['api_info']['category_name'] not in category_dict:
                category_dict[json_item['api_info']['category_name']] = [json_item['api_id']]
            else:
                category_dict[json_item['api_info']['category_name']].append(json_item['api_id'])
        
        for api_id, api_json in self.id2api.items():
            self.id2tool[api_id] = tool_dict[api_json['tool_name']]
            self.id2category[api_id] = category_dict[api_json['category_name']]
    
    def load_generator(self):
        return self.generator.load_generator()
        
    def run(self, api):
        
        if self.action == Action.Format:
            return self.generator.run(api, self.id2tool, self.id2category, self.id2api)
        else:
            return self.generator.run(api)
