from .profile import Profile
from .registry import auto_register
import json


@auto_register("generator")
class GeneratorProfile(Profile):
    
    def __init__(self, args) -> None:
        super().__init__(args)
        
    def load_policy(self):
        return self.config["policy"]
        
    def load_env(self):
        return self.config["api_env"]

    def load_output(self):
        return self.config["output"]
        
    def load_input(self):
        return self.config["input"]

    def load_template(self, key):
        return json.load(open(self.config["prompt"][key]))
        
    def load_examples(self, key, data_type):
        return json.load(open(self.config["examples"][key][data_type]))

