from abc import ABC
from abc import abstractmethod
from utils import log
import json


class Profile(ABC):
    
    def __init__(self, args) -> None:
        
        self.logger = log.get_loguru()
        self.args = args
        
        self.config = self._load_config(self.args.config_file)
    
    def _load_config(self, config_file):
        return json.load(open(config_file))
    
    @abstractmethod
    def load_policy(self, *args, **kwargs):
        return NotImplemented
