import argparse
from utils import log
from parallel.runner import InstanceQueue
from profile.registry import ProfileRegistry
from agent.registry import AgentRegistry


def run(args):
    
    parallel_number = args.parallel_number
    logger = log.get_loguru()
    logger.info(
        "Run Simulator with <{}>".format(
            "Parallel Execution" if parallel_number > 1 else "Step-by-Step Execution..."
        )
    )
    
    # Load Simulator configuration
    profile = ProfileRegistry.create_instance(args.agent, args)
    data_generator = profile.load_data(args.lazy_load, args.max_instance)
    
    # Load agent
    agent = AgentRegistry.create_instance(args.agent, profile)
    
    # Put the data into the message queue and run in parallel
    instance_queue = InstanceQueue(parallel_number, asyncio=False)
    instance_queue.run(agent, data_generator)
    
    # Persist the data into a JSON file.
    agent.finalize()    
    logger.info("Simulator Down...")


if __name__ == "__main__":
    
    parser = argparse.ArgumentParser(description="auto evalutation and generation")
    parser.add_argument(
        "-c",
        "--config-file",
        type=str,
        default="conf/auto_config.yaml",
        help="The file of configuration.",
    )
    parser.add_argument(
        "-p",
        "--parallel-number",
        type=int,
        default=1,
        help="The number of concurrent API calls.",
    )
    parser.add_argument(
        "-a",
        "--agent",
        type=str,
        default="api_agent",
        help="The type of Agent.",
    )
    parser.add_argument(
        "-l",
        "--lazy-load",
        action="store_true",
        help="Load Data with lazy Approach",
    )
    parser.add_argument(
        "-m",
        "--max-instance",
        type=int,
        default=-1,
        help="The number of max sample.",
    )
    args = parser.parse_args()
    run(args)
