from loguru import logger
import sys


# set global loguru instance
lock_loguru = None

def colorize_message(message):
    
    if "[error]" in message:
        return f"<red>{message}</red>"
    elif "[assistant]" in message:
        return f"<yellow>{message}</yellow>"
    elif "[user]" in message:
        return f"<green>{message}</green>"
    elif "[tool]" in message:
        return f"<blue>{message}</blue>"
    else:
        return f"<white>{message}</white>"

def custom_format(record):
    message = record["message"].replace("<", "[").replace(">", "]").replace("{", "[").replace("}", "]")
    colored_message = colorize_message(message)
    return f"{record['time']:YYYY-MM-DD HH:mm:ss} | {record['level']: <8} | {colored_message}\n"


def get_loguru():
    
    global lock_loguru
    if lock_loguru is None:
        
        logger.remove()
        logger.add(sys.stdout, format=custom_format, colorize=True, level="INFO", enqueue=True)
        logger.add("logfiles/log.txt", rotation="10 MB", level="INFO", enqueue=True)
        lock_loguru = logger
    
    return lock_loguru
