from utils import log
import json


class AgentHandler:
    '''
        store data in the database, including load, update, and save functions.
    '''
    def __init__(self, db_server) -> None:
        self.logger = log.get_loguru()
        self.db = db_server

    def build_action_db(self, table_name, feild_list):
        self.db.init_table(table_name, feild_list)

    def load_action_feedback(self, session_id, table_name, feild_name, action_param={}):
        
        if len(action_param):
            return self._load_action_feedback(None, table_name, feild_name, action_param)
        else:
            return self._load_action_feedback(session_id, table_name, feild_name, action_param)

    def _load_action_feedback(self, session_id, table_name, feild_name, action_param):
        
        if len(action_param):
            action_feedback_dict_serial = self.db.get_feild_by_param(
                table_name, feild_name, action_param
            )
        else:
            action_feedback_dict_serial = self.db.get_feild_by_id(
                table_name, feild_name, session_id
            )
        
        if len(action_feedback_dict_serial):
            if action_feedback_dict_serial[feild_name] is None:
                return {}
            else:
                action_feedback_dict = json.loads(
                    action_feedback_dict_serial[feild_name]
                )
                return action_feedback_dict
        else:
            return None
    
    def save_action_feedback(
        self, session_id, table_name, feild_name, action_feedback_dict, action_param={}
    ):
        if len(action_param):
            self._save_action_feedback(None, table_name, feild_name, action_param, action_feedback_dict)
        else:
            self._save_action_feedback(session_id, table_name, feild_name, action_param, action_feedback_dict)
    
    def _save_action_feedback(
        self, session_id, table_name, feild_name, action_param, action_feedback_dict
    ):
        if len(action_param):
            if self.db.exist_by_param(table_name, action_param):
                self.update_action_feedback(
                    None, table_name, feild_name, action_feedback_dict, action_param=action_param
                )
            else:
                action_feedback_dict_serial = json.dumps(
                    action_feedback_dict, ensure_ascii=False
                )
                self.db.save_feild_by_param(
                    table_name, feild_name, action_feedback_dict_serial, action_param
                )
        else:
            if self.db.exist(table_name, session_id):
                self.update_action_feedback(
                    session_id, table_name, feild_name, action_feedback_dict
                )
            else:
                action_feedback_dict_serial = json.dumps(
                    action_feedback_dict, ensure_ascii=False
                )
                self.db.save_feild(
                    table_name, session_id, feild_name, action_feedback_dict_serial
                )
    
    def update_action_feedback(
        self, session_id, table_name, feild_name, action_feedback_dict, action_param={}
    ):
        if len(action_param):
            self._update_action_feedback(None, table_name, feild_name, action_param, action_feedback_dict)
        else:
            self._update_action_feedback(session_id, table_name, feild_name, action_param, action_feedback_dict)
    
    def _update_action_feedback(
        self, session_id, table_name, feild_name, action_param, action_feedback_dict
    ):
        
        action_feedback_dict_serial = json.dumps(
            action_feedback_dict, ensure_ascii=False
        )
        if len(action_param):
            self.db.update_feild_by_param(
                table_name, feild_name, action_feedback_dict_serial, action_param
            )
        else:
            self.db.update_feild(
                table_name, feild_name, session_id, action_feedback_dict_serial
            )
