from parallel.runner import InstanceQueue
from profile.registry import ProfileRegistry
from pipeline.rapid_collector import RapidCollector
from pipeline.leetcode_collector import LeetcodeCollector
from utils import log
from enum import Enum
import argparse


def run(args):

    parallel_number = args.parallel_number
    logger = log.get_loguru()
    logger.info(
        "Run API Collector with <{}>".format(
            "Parallel Execution" if parallel_number > 1 else "Step-by-Step Execution..."
        )
    )

    profile = ProfileRegistry.create_instance("collector", args)

    if args.env == Env.Rapid:
        collector = RapidCollector(profile)
    elif args.env == Env.Leetcode:
        collector = LeetcodeCollector(profile)

    if args.action == Action.Rapid or args.action == Action.Leetcode:
        data_generator = collector.load_tool_generator()
        exector = collector.run_tool
    elif args.action == Action.xLAM:
        data_generator = collector.load_xlam_generator()
        exector = collector.run_xlam_api
    elif args.action == Action.Merge:
        data_generator = collector.load_merge_generator()
        exector = collector.run_merge_api
    elif args.action == Action.Check_Param:
        data_generator = collector.load_check_generator()
        exector = collector.run_check_parameter
    
    if parallel_number > 0:
        instance_queue = InstanceQueue(parallel_number, asyncio=False)
        instance_queue.run_param(exector, data_generator)
    else:
        for idx, d in enumerate(data_generator):
            exector(d)
    
    if args.action == Action.Merge:
        collector.merge()
    if args.action == Action.Check_Param:
        collector.merge_check()

    logger.info("Run API Collector End")


class Env(Enum):

    Rapid = 'rapid'
    Leetcode = 'leetcode'

class Action(Enum):

    Rapid = "rapid"
    Leetcode = 'leetcode'
    xLAM = "xlam"
    Merge = "merge"
    Check_Param = "check_parameter"

if __name__ == "__main__":
    
    parser = argparse.ArgumentParser(description="auto collector")
    parser.add_argument(
        "-c",
        "--config-file",
        type=str,
        default="profiles/rapid_profile/collector/config.json",
        help="The file of configuration.",
    )
    parser.add_argument(
        "-p",
        "--parallel-number",
        type=int,
        default=1,
        help="The number of concurrent API calls.",
    )
    parser.add_argument(
        "-e",
        '--env',
        type=Env,
        choices=list(Env),
        required=True,
        help="choose a env from list"
    )
    parser.add_argument(
        "-a",
        '--action',
        type=Action,
        choices=list(Action),
        required=True,
        help="choose a action from list"
    )
    args = parser.parse_args()
    run(args)
