from parallel.runner import InstanceQueue
from profile.registry import ProfileRegistry
from pipeline.rapid_generator import RapidGenerator
from pipeline.leetcode_generator import LeetcodeGenerator
from pipeline.generator.base import Action
from utils import log
from enum import Enum
import argparse


def run(args):

    parallel_number = args.parallel_number
    logger = log.get_loguru()
    logger.info(
        "Run API Generator with <{}>".format(
            "Parallel Execution" if parallel_number > 1 else "Step-by-Step Execution..."
        )
    )
    
    profile = ProfileRegistry.create_instance("generator", args)
    
    if args.env == Env.Rapid:
        generator = RapidGenerator(profile, args.action)
    elif args.env == Env.Leetcode:
        generator = LeetcodeGenerator(profile, args.action)
    
    data_generator = generator.load_generator()
    exector = generator.run
    
    if parallel_number > 0:
        instance_queue = InstanceQueue(parallel_number, asyncio=False)
        instance_queue.run_param(exector, data_generator)
    else:
        for idx, d in enumerate(data_generator):
            exector(d)

    if args.action == Action.Multiple:
        generator.run_multiple_sampling()

    logger.info("Run API Generator End")


class Env(Enum):

    Rapid = 'rapid'
    Leetcode = 'leetcode'


if __name__ == "__main__":
    
    parser = argparse.ArgumentParser(description="auto collector")
    parser.add_argument(
        "-c",
        "--config-file",
        type=str,
        default="profiles/rapid_profile/collector/config.json",
        help="The file of configuration.",
    )
    parser.add_argument(
        "-p",
        "--parallel-number",
        type=int,
        default=1,
        help="The number of concurrent API calls.",
    )
    parser.add_argument(
        "-e",
        '--env',
        type=Env,
        choices=list(Env),
        required=True,
        help="choose a env from list"
    )
    parser.add_argument(
        "-a",
        '--action',
        type=Action,
        choices=list(Action),
        required=True,
        help="choose a action from list"
    )
    args = parser.parse_args()
    run(args)
