from .profile import Profile
from .registry import auto_register
import json


@auto_register("sampler")
class SamplerProfile(Profile):

    def __init__(self, args) -> None:
        super().__init__(args)
    
    def load_policy(self):
        return self.config["policy"]
        
    def load_env(self):
        return self.config["api_env"]

    def load_output(self):
        return self.config["output"]
        
    def load_input(self):
        return self.config["input"]