from openai import OpenAI
import random


class LLMPolicy:

    def __init__(self, profile):
        
        self.profile = profile
        self.parameter = self.profile.load_policy()

        self.model = self.parameter['model']
        self.max_tokens = self.parameter['max_tokens']
        self.temperature = self.parameter['temperature']
        self.top_p = self.parameter['top_p']
        self.port = self.parameter['port']


    def __call__(self, raw_messages):

        if isinstance(raw_messages, str):
            messages = [{"role": "user", "content": raw_messages}]
        elif isinstance(raw_messages, list):
            messages = raw_messages
        else:
            raise Exception("Prompt Format Error")

        dist_port = str(random.choice(self.port))
        client = OpenAI(
            api_key="EMPTY",
            base_url=self.parameter['url'].replace(str(self.port[0]), dist_port),
        )

        response = client.chat.completions.create(
            model=self.model,
            messages=messages,
            max_tokens=self.max_tokens,
            temperature=self.temperature,
            top_p=self.top_p,
            presence_penalty=0.3,
        )

        result = response.choices[0].message.content
        result = result.replace("<|assistant|>", "")
        return result