# <span style="font-variant: small-caps;">Zebra</span>: Towards Zero-Shot Cross-Subject Generalization for Universal Brain Visual Decoding

<div align="center">



</div>





## 🛠️ Installation & Setup


### 🖥️ Environment Setup


```bash
conda create -n train python==3.10
conda activate train
pip install -r requirements.txt
```




### ⚙️ Pretrained Weights Preparation

```shell
mkdir pretrained_weights
cd pretrained_weights
wget -O unclip6_epoch0_step110000.ckpt -c https://huggingface.co/datasets/pscotti/mindeyev2/resolve/main/unclip6_epoch0_step110000.ckpt\?download\=true
wget -O last.pth -c https://huggingface.co/datasets/pscotti/mindeyev2/resolve/main/train_logs/final_subj01_pretrained_40sess_24bs/last.pth\?download\=true
wget -O convnext_xlarge_alpha0.75_fullckpt.ckpt -c https://huggingface.co/datasets/pscotti/mindeyev2/resolve/main/convnext_xlarge_alpha0.75_fullckpt.pth\?download\=true
wget -O sd_image_var_autoenc.pth https://huggingface.co/datasets/pscotti/mindeyev2/resolve/main/sd_image_var_autoenc.pth?download=true
```


## 🚀 Quick Start
This codebase allows train, test, and evaluate using one single bash file.

```
bash train_zebra.sh 0 zebra 1234567 last 1
```


------
Parameters:

`$1`: use which gpu to train

`$2`: train file postfix, e.g, `train_zebra`


`$3`: run which stage:
- `1`: train brain model
- `2`: train prior
- `3`: recon images
- `4`: eval recon without enhance
- `5`: caption images
- `6`: enhanced recon
- `7`: eval final results

`$4`: inference ckpt: `['prior', 'last']`

`$5`: test which subject: `[0,1,2]`

----
Note that for convenience of debugging, `use_wandb` is set to `False` be default. 

If you would like to use wandb, first run `wandb login` and set the `use_wandb` to `True` in `train_zebra.py`.


