# Setting up environment with `virtualenv`

The following set of commands can be used to set up an environment to reproduce
our experiments. We make Orbit available as a test-pypi artifact making it
easily installable and reproducible. However, we request that the reviewer not
pursue the code for the test-pypi to respect double-blindedness.

```
> mkdir repenv
> virtualenv -p /usr/bin/python3.9 repenv
> source repenv/bin/activate
> pip install -r requirements.txt
> pip install --upgrade --index-url https://test.pypi.org/simple/ lale
```

# Current results

The results of our executions are available in the `raw_results` directory made
available as part of the tar-ball. However, if the reviewer wants to re-run the
experiments, we request that the `raw_results` directory is moved to some other
location before continuing with running the experiments.


# Generating results for Figure 1

First, we need to create a results directory:

```
> mkdir raw_results
```

Then we make use of the `run_gridsearch.py` and run the script once with each of
the following lines (lines 40-42) uncommented one at a time:

```
# from fig1_run1 import GRID
# from fig1_run2 import GRID
# from fig1_run3 import GRID
```

This will save all relevant results in the `raw_results` directory.

# Generating results for RQ1

We make use of the `run_gridsearch.py` and run the script once with each of the
following lines (lines 46-50) uncommented one at a time:

```
# from rq1_run1 import GRID
# from rq1_run2 import GRID
# from rq1_run3 import GRID
# from rq1_run4 import GRID
# from rq1_run5 import GRID
```

This will save all relevant results in the `raw_results` directory.

# Generating results for RQ2

We make use of the `run_gridsearch.py` and run the script once with each of the
following lines (lines 54-59) uncommented one at a time:

```
# from rq2_run1 import GRID
# from rq2_run2 import GRID
# from rq2_run3 import GRID
# from rq2_run4 import GRID
# from rq2_run5 import GRID
# from rq2_run6 import GRID
```

This will save all relevant results in the `raw_results` directory.

# Generating results for RQ3

For RQ3, we can just execute the `run_hyperopt.py` script as follows:

```
> python run_hyperopt.py
```

This will save all the results for RQ3 in the `raw_results` directory.


# Generating plots

Given the `raw_results` directory, we can run the `analyze_results.ipynb` to
generate all the plots presented in the paper. Note that the notebook would need
to be run with the `repenv` virtual environment.