from solver import ThreePartitionSolver

def ThreePartitionVerifier(input_sample, output_sample, **kwargs):
    answer = ThreePartitionSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return ThreePartitionVerifier

if __name__ == '__main__':
    input_sample = [1, 2, 5, 6, 7, 9]
    output_sample = "YES"
    print(ThreePartitionVerifier(input_sample, output_sample)) ## True

    input_sample = [1, 2, 5, 6, 7, 9]
    output_sample = "NO"
    print(ThreePartitionVerifier(input_sample, output_sample)) ## False