import re

def has_integer_in_string(input_string):
    elements = input_string.split()
    for element in elements:
        try:
            int(element)
            return True
        except ValueError:
            continue
    return False

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    assert len(input_text) == 1
    return list(map(int, input_text[0].split()))

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                'OUTPUT': None,
                'ERROR': 'output file should have atleast one non-empty line'
            }
        if has_integer_in_string(output_text[0]):
            ## triplets
            triplets = []
            for line in output_text:
                triplets.append(list(map(int, line.strip().split())))
            return {
                'OUTPUT': triplets,
                'ERROR': None,
            }
        else:
            ## NO
            if num_lines  > 1 or 'NO' not in output_text[0]:
                return {
                    'OUTPUT': None,
                    'ERROR': 'Could not parse output.txt, output format should match description'
                }
            return {
                'OUTPUT': 'NO',
                'ERROR': None
            }
                
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }    
        
         

def input_to_text_string(input_sample, **kwargs):
    return " ".join(map(str, input_sample))

def output_to_text_string(output_sample, **kwargs):
    if isinstance(output_sample, str):
        return output_sample
    return "\n".join(" ".join(list(map(str, triplet))) for triplet in output_sample)