import numpy as np

def check_board(input_board):
    ### returns (Boolean (whether board is correct), Reason) Reason contains why board is not right if it is incorrect
    input_board = np.array(input_board)
    # print(input_board.shape)
    N, M = input_board.shape
    
    if (N != M) or (N%2 != 0):
        return (False, "Output Board is of incorrect shape")

    # Get unique elements and their counts
    unique_elements, counts = np.unique(input_board, return_counts=True)
    if(len(unique_elements) != 2):
        return (False, "Output Board should contain only 1s and 0s")
    
    if(unique_elements[0] != 0 and unique_elements[1]!=1):
        return (False, "Output Board should contain only 1s and 0s")

    for i in range(N):
        row_sum = np.sum(input_board[i, :])
        column_sum = np.sum(input_board[:, i])
        if (row_sum != N/2):
            return (False, f"Unequal Number of 1s and 0s in row: {i+1} of Output Board")
        if (column_sum != N/2):
            return (False, f"Unequal Number of 1s and 0s in col: {i+1} of Output Board") 
    
    for i in range(N):
        for j in range(i+1, N):
            if np.array_equal(input_board[i], input_board[j]):
                return (False, f"Rows {i+1} and {j+1} are equal in the Output Board")
            if np.array_equal(input_board[:, i], input_board[:, j]):
                return (False, f"Columns {i+1} and {j+1} are equal in the Output Board")
            
    for i in range(N):
        for j in range(j, N-2):
            row_sum = input_board[i][j] + input_board[i][j+1] + input_board[i][j+2]
            if (row_sum % 3 == 0):
                return (False, f"3 Consecutive {row_sum//3}s horizontally on the output board")
            column_sum = input_board[j][i] + input_board[j+1][i] + input_board[j+2][i]  
            if (column_sum % 3 == 0):
                return (False, f"3 Consecutive {column_sum//3}s vertically on the output board")
    
    return (True, None)

def BinairoVerfier(input, output, **kwargs):
    input = np.array(input)
    output = np.array(output)
    
    N_in, N_out = input.shape[0], output.shape[0]
    if N_in != N_out:
        return {
            "result": False,
            "reason": "Boards Size of Input and Output Don't Match!"
        }
    if output.shape[0] != output.shape[1]:
        return {
           "result": False,
           "reason": "Output Board is not a Square"
        }
    
    for i in range(N_in):
        for j in range(N_out):
            if (input[i][j] == '1' or input[i][j] == 1):
                if (output[i][j] != '1' and output[i][j] !=1):
                    return {
                        "result": False,
                        "reason": f"Originial Pieces Removed from Board (At index ({i}, {j}))"
                    }
            if (input[i][j] == '0' or input[i][j] == 0):
                if (output[i][j] != '0' and output[i][j] !=0):
                    return {
                        "result": False,
                        "reason": f"Originial Pieces Removed from Board (At index ({i}, {j}))"
                    }
            
                
    is_board_correct, invalidity_reason = check_board(output)
    
    if is_board_correct:
        return {
            "result": True,
            "reason": None
        }
    else:
        return{
            "result": False,
            "reason": invalidity_reason
        }
    
def MyVerifier():
    return BinairoVerfier

if __name__ == "__main__":
    
    input = np.array([
    [0,   1,   1,  0],
    [0,  '?', '?', '?'],
    ['?', 0,  '?', 0],
    [1,   0,   0,  1]])

    output = np.array([
            [0, 1, 1, 0],
            [0, 1, 0, 1],
            [1, 0, 1, 0],
            [1, 0, 0, 1],])
    print(BinairoVerfier(input, output))
    
    board = np.array([
    [0, 1, 1, 0],
    [0, 1, 0, 1],
    [1, 0, 1, 0],
    [1, 0, 0, 1]])
    print(check_board(board))



