import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    num_cars, num_options, num_classes = tuple(map(int, input_text[0].split()))
    cars_per_option = list(map(int, input_text[1].split()))
    block_sizes = list(map(int, input_text[2].split()))
    cars_per_class = list(map(int, input_text[3].split()))
    class_data = [list(map(int, row.split())) for row in input_text[4:]]
    return {
        'num_cars': num_cars,
        'num_options': num_options,
        'num_classes' : num_classes,
        'cars_per_option': cars_per_option,
        'block_sizes': block_sizes,
        'cars_per_class': cars_per_class,
        'class_data': class_data
    }


def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        if num_lines > 1:
            return {
                "OUTPUT": None,
                "ERROR": "Output should have a single line of space seperated integers"
            }
        output_list = list(map(int, output_text[0].strip().split()))
        return {
            'OUTPUT': output_list,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    num_cars = input_sample['num_cars']
    num_options = input_sample['num_options']
    num_classes = input_sample['num_classes']
    cars_per_option = input_sample['cars_per_option']
    block_sizes = input_sample['block_sizes']
    cars_per_class = input_sample['cars_per_class']
    class_data = input_sample['class_data']
    
    first_line = f"{num_cars} {num_options} {num_classes}"
    second_line = " ".join(map(str, cars_per_option))
    third_line =  " ".join(map(str, block_sizes))
    fourth_line =  " ".join(map(str, cars_per_class))
    class_data_lines = "\n".join(" ".join(map(str, row)) for row in class_data)
    
    return "\n".join([first_line, second_line, third_line, fourth_line, class_data_lines])
    

def output_to_text_string(output_sample, **kwargs) -> str:
    return " ".join(map(str, output_sample))