
import numpy as np

def CarSequencingVerifier(input_sample, output_sample, **kwargs):
    num_cars = input_sample['num_cars']
    num_options = input_sample['num_options']
    num_classes = input_sample['num_classes']
    
    cars_per_option = input_sample['cars_per_option']
    block_sizes = input_sample['block_sizes']
    
    cars_per_class = input_sample['cars_per_class']
    class_data = input_sample['class_data']
    
    if len(output_sample) != num_cars:
        return {
            'result': False,
            'reason': f"Output should have {num_cars} seperated integers"
        }
    
    for car_class in range(1, num_classes+1):
        if output_sample.count(car_class) != cars_per_class[car_class-1]:
            return {
                'result': False,
                'reason': f"Output should have {cars_per_class[car_class-1]} cars with class {car_class}"
            }
        
            
    options_array = np.zeros((num_cars, num_options), dtype=np.int32)
    for slot in range(num_cars):
        if output_sample[slot] <= 0 or output_sample[slot] > num_classes:
            return {
                'result': False,
                'reason': f"Output should have elements from 1-{num_classes}"
            }
        for option in range(num_options):
            if class_data[output_sample[slot]-1][option]:
                options_array[slot][option] += 1
    
    for option in range(num_options):
        for block_start in range(0, num_cars-block_sizes[option]+1):
            workers_required = np.sum(options_array[block_start:block_start+block_sizes[option], option])
            if workers_required > cars_per_option[option]:
                return {
                    'result': False,
                    'reason': f"Maximum options in a block constraint violated"
                }
        
    
    
    return {
        'result': True,
        'reason': None
    }
    
def MyVerifier():
    return CarSequencingVerifier

if __name__ == '__main__':
    # Sample Input
    input_sample = {
        'num_cars': 10,
        'num_options': 5,
        'num_classes' : 6,
        'cars_per_option': [1, 2, 1, 2, 1],
        'block_sizes': [2, 3, 3, 5, 5],
        'cars_per_class': [1, 1, 2, 2, 2, 2],
        'class_data': [
            [1, 0, 1, 1, 0], ### options required by class i
            [0, 0, 0, 1, 0],
            [0, 1, 0, 0, 1],
            [0, 1, 0, 1, 0],
            [1, 0, 1, 0, 0],
            [1, 1, 0, 0, 0]
        ]
    }
    output_sample = [6, 3, 5, 4, 4, 5, 3, 6, 2, 1]
    print(CarSequencingVerifier(input_sample, output_sample)) ## True
    
    output_sample = [1, 2, 6, 3, 5, 4, 4, 5, 3, 6 ]
    print(CarSequencingVerifier(input_sample, output_sample)) ## True
    
    output_sample = [1, 3, 6, 2, 5, 4, 3, 5, 4, 6]
    print(CarSequencingVerifier(input_sample, output_sample)) ## True
    
    output_sample = [1, 3, 6, 2, 6, 4, 5, 3, 4, 5]  ## True
    print(CarSequencingVerifier(input_sample, output_sample))
     
    output_sample = [5, 4, 3, 5, 4, 6, 2, 6, 3, 1]  ## True
    print(CarSequencingVerifier(input_sample, output_sample))
    
    output_sample = [6, 3, 5, 4, 4, 5, 3, 6, 2, 1]  ## True
    print(CarSequencingVerifier(input_sample, output_sample))

    output_sample = [6, 4, 5, 3, 4, 5, 2, 6, 3, 1]  ## True
    print(CarSequencingVerifier(input_sample, output_sample))

    output_sample = [4, 6, 5, 3, 4, 5, 2, 6, 3, 1]  ## False
    print(CarSequencingVerifier(input_sample, output_sample))