from solver import CliqueCoverSolver

def CliqueCoverVerifier(input_sample, output_sample, **kwargs):
    answer = CliqueCoverSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else 'The generated answer is wrong'
    }

def MyVerifier():
    return CliqueCoverVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 9,
        'edges' : [(0,1), (1,3), (2, 3), (0, 2), (1, 4), (3, 4), (4, 5), (5, 6), (6, 7), (7, 8), (5, 8), (6, 8), (5, 7)],
        'k': 3
    } ## YES
    output_sample = "YES"
    print(CliqueCoverVerifier(input_sample=input_sample, output_sample=output_sample)) ## True

    input_sample = {
        'number_of_nodes': 9,
        'edges' : [(0,1), (1,3), (2, 3), (0, 2), (1, 4), (3, 4), (4, 5), (5, 6), (6, 7), (7, 8), (5, 8), (6, 8), (5, 7)],
        'k': 3
    } ## YES
    output_sample = "NO"
    print(CliqueCoverVerifier(input_sample=input_sample, output_sample=output_sample)) ## False