import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    assert len(input_text) == 4 ### two operands, one operand and one target
    if kwargs['n'] is not None:
        assert len(input_text[0]) == kwargs['n']
        assert len(input_text[1]) == kwargs['n']
    return {
        "operands": (input_text[0], input_text[1]),
        "operator": input_text[2],
        "target": input_text[3]
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        output = dict()
        for line in output_text:
            if len(line.strip().split()) != 2:
                return {
                    "OUTPUT": None,
                    "ERROR": "Each output line must be a letter followed by a space followed by a digit to which the letter corresponds" 
                }
            letter = line.strip().split()[0]
            digit = int(line.strip().split()[1])
            if digit < 0 or digit > 9:
                return {
                    "OUTPUT": None,
                    "ERROR": 'Each letter must map to a digit from 0-9'
                }
            output[letter] = digit
        return {
            "OUTPUT": output,
            "ERROR": None,
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    operands = input_sample["operands"]
    target = input_sample["target"]
    operator = input_sample["operator"]
    operands = '\n'.join(operands)
    return f"{operands}\n{operator}\n{target}"

def output_to_text_string(output_sample, **kwargs):
    return "\n".join(f"{k} {v}" for k, v in output_sample.items())