def CryptarithmeticVerifier(input_sample, output_sample, **kwargs):
    input_words = list(input_sample["operands"])
    target_word = input_sample["target"]
    operator = input_sample["operator"]
    unique = kwargs['unique'] if 'unique' in kwargs else True
    output_mapping = output_sample
    
    all_words = input_words + [target_word]
    letters = set([l for l in "".join(all_words)])
    if len(letters) != len(output_mapping):
        return {
            'result': False,
            'reason': "Number of Distinct Letters in Input and Length of Output Mapping do not match"
        }
    for letter in letters:
        if letter not in output_mapping:
            return {
                'result': False,
                'reason': f"Letter: {letter} missing in output mapping"
            }
    if unique:
        if (len(output_mapping.values()) != len(set(output_mapping.values()))):
            return {
                'result': False,
                'reason': "Unique mapping constraint not satisfied"
            }
    mapped_input_words = []
    for input_word in input_words:
        mapped_input_words.append(("".join(str(output_mapping[letter]) for letter in input_word)))
    mapped_input_words = [str(int(word)) for word in mapped_input_words] ### to remove leading zeros
    mapped_target =  ("".join((str(output_mapping[letter])) for letter in target_word))
    mapped_target = str(int(mapped_target))
    eval_string = f"{operator.join(mapped_input_words)} == {mapped_target}"
    correct = eval(eval_string)
    return {
        'result': correct,
        'reason': None if correct else "Output Mapping incorrect since it does not satisfy arithmetic conditions"
    }

def MyVerifier():
    return CryptarithmeticVerifier

if __name__ == "__main__":
    print(CryptarithmeticVerifier(input_sample={
                                  'operands': ["SEND", "MORE"],
                                  'target': "MONEY",
                                  'operator': "+"
                                },
                                  output_sample={
                                      'S': 9,
                                      'E': 5,
                                      'N': 6,
                                      'D': 7,
                                      'M': 1,
                                      'O': 0,
                                      'R': 8,
                                      'Y': 2},
                                  unique=True))
    print(CryptarithmeticVerifier(input_sample={
                                 'operands': ["AB", "BA"],
                                  'target': "BCB",
                                  'operator': "*"
                                },
                                  output_sample={
                                      'A': 1,
                                      'B': 2,
                                      'C': 5},
                                  unique=True))
    print(CryptarithmeticVerifier(input_sample = {
                                  'operands': ["AB", "CA"],
                                  'target': "BCB",
                                  'operator': "*"
                                 },
                                  output_sample={
                                      'A': 1,
                                      'B': 2,
                                      'C': 5},
                                  unique=True))
    print(CryptarithmeticVerifier(input_sample={
                                  'operands': ["AB", "BA"],
                                  'target':"ACA",
                                  'operator':"*",
                                  },
                                  output_sample={
                                      'A': 1,
                                      'B': 1,
                                      'C': 2},
                                  unique=True))
    print(CryptarithmeticVerifier(input_sample=
                                  {
                                  'operands': ["AB", "BA"],
                                  'target': "ACA",
                                  'operator':"*",
                                  },
                                  output_sample={
                                      'A': 1,
                                      'B': 1,
                                      'C': 2},
                                  unique=False))
    