import re

SEPERATOR_STRING = "--------"
def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    board_text, grids_text = None, None
    seperator_idx = input_text.index(SEPERATOR_STRING)
    board_text = input_text[:seperator_idx]
    grids_text = input_text[seperator_idx+1:]
    input_board = [list(map(int, row.strip().split())) for row in board_text]
    subgrids = []
    for row in grids_text:
        subgrids.append(list(map(int, row.strip().split())))
    return {
        "input_board": input_board,
        "subgrids": subgrids,
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                "OUTPUT": None,
                "ERROR": "Output is Empty"
            }
        output_board = []
        for row in output_text:
            if len(row.strip().split()) != num_lines:
                return {
                "OUTPUT": None,
                "ERROR": f"Output Board must be square shaped"
            }
            output_board.append(list(map(int, row.strip().split())))
        return {
            "OUTPUT": output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    input_board = input_sample['input_board']
    subgrids = input_sample['subgrids']
    input_board_string = "\n".join(" ".join(map(str, row)) for row in input_board)
    subgrids_string = "\n".join(" ".join(list(map(str, subgrid))) for subgrid in subgrids)
    return "\n".join((input_board_string, SEPERATOR_STRING, subgrids_string))

def output_to_text_string(output_sample, **kwargs):
    return "\n".join(" ".join(list(map(str, row))) for row in output_sample)
