import re

SEPERATOR_STRING = '--------'
def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    seperator_idx = input_text.index(SEPERATOR_STRING)
    factories_workers_text = input_text[:seperator_idx]
    workers_jobs_text = input_text[seperator_idx+1:]
    factories_workers =  [list(map(int, row.strip().split())) for row in factories_workers_text]
    workers_jobs =  [list(map(int, row.strip().split())) for row in workers_jobs_text]
    return {
        'factories_workers': factories_workers,
        'workers_jobs': workers_jobs
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
        if "YES" in output_text[0].upper() and "NO" not in output_text[0].upper():
            return {
                "OUTPUT": "YES",
                "ERROR": None
            }
        
        if "NO" in output_text[0].upper() and "YES" not in output_text[0].upper():
            return {
                "OUTPUT": "NO",
                "ERROR": None
            }
    
        return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    factories_workers = input_sample['factories_workers']
    workers_jobs = input_sample['workers_jobs']
    factory_wokers_string = "\n".join(" ".join(map(str, row)) for row in factories_workers)
    workers_jobs_string = "\n".join(" ".join(map(str, row)) for row in workers_jobs)
    return f"{factory_wokers_string}\n{SEPERATOR_STRING}\n{workers_jobs_string}"

def output_to_text_string(output_sample, **kwargs):
    return output_sample