from solver import FactoryWorkersSolver

def FactorWorkerVerifier(input_sample, output_sample, **kwargs):
    answer = FactoryWorkersSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return FactorWorkerVerifier

if __name__ == '__main__':
    input_sample = {
        'factories_workers': [[1, 2], [3, 4], [5, 6]], ## each list is a factory and ID of workers working in that factory
        'workers_jobs': [[1, 3, 5], [2, 4, 6], [1, 6]] ## each list is a job and worker IDs capable of doing it
    }
    output_sample = "YES"
    print(FactorWorkerVerifier(input_sample, output_sample)) ## True

    input_sample = {
        'factories_workers': [[1, 2], [3, 4], [5, 6]], ## each list is a factory and ID of workers working in that factory
        'workers_jobs': [[1, 3, 5], [2, 4, 6], [1, 6]] ## each list is a job and worker IDs capable of doing it
    }
    output_sample = "NO"
    print(FactorWorkerVerifier(input_sample, output_sample)) ## False