
from z3 import *

# Puzzle 1 from
# http://www.conceptispuzzles.com/index.aspx?uri=puzzle/fill-a-pix/rules



def makeIntVar(sol,name,min_val, max_val):
    v = Int(name)
    sol.add(v >= min_val, v <= max_val)
    return v

def FillAPixSolver(input_sample, **kwargs):

  puzzle = input_sample
  n = len(puzzle)
  sol = SolverFor("QF_FD")

  # for the neighbors of 'this' cell
  S = [-1, 0, 1]

  # declare variables
  pict = {}
  for i in range(n):
    for j in range(n):
      pict[(i, j)] = makeIntVar(sol, f'pict {i} {j}', 0, 1)

  pict_flat = [pict[i, j] for i in range(n) for j in range(n)]


  # constraints
  for i in range(n):
    for j in range(n):
      if puzzle[i][j] != 'X':
        # this cell is the sum of all the surrounding cells
        sol.add(
            int(puzzle[i][j]) == Sum([pict[i + a, j + b]
                                        for a in S for b in S
                                        if i + a >= 0 and
                                        j + b >= 0 and
                                        i + a < n and
                                        j + b < n])
        )

  if sol.check() == sat:
    mod = sol.model()
    output_board = []
    for i in range(n):
      row = [mod.eval(pict[i, j]).as_long() for j in range(n)]
      output_board.append(row)
    return [output_board]
  else:
    raise Exception("No Solution")

def MySolver():
    return FillAPixSolver

if __name__ == '__main__':

    X = 'X'
    input_sample = [
        [X, X, X, X, X, X, X, X, 0, X],
        [X, 8, 8, X, 2, X, 0, X, X, X],
        [5, X, 8, X, X, X, X, X, X, X],
        [X, X, X, X, X, 2, X, X, X, 2],
        [1, X, X, X, 4, 5, 6, X, X, X],
        [X, 0, X, X, X, 7, 9, X, X, 6],
        [X, X, X, 6, X, X, 9, X, X, 6],
        [X, X, 6, 6, 8, 7, 8, 7, X, 5],
        [X, 4, X, 6, 6, 6, X, 6, X, 4],
        [X, X, X, X, X, X, 3, X, X, X]
    ]
    print(FillAPixSolver(input_sample))