import numpy as np

def FillAPixVerifier(input_sample, output_sample):
    n = len(input_sample)  # Assuming the input is a square grid
    S = [-1, 0, 1]  # Offsets for neighbors

    input_sample = np.array(input_sample)
    output_sample = np.array(output_sample)

    if (input_sample.shape) != (output_sample.shape):
        return {
            "result": False,
            "reason": "Input and Output Boards do not have the same shape",
        }
    
    for i in range(n):
        for j in range(n):
            if input_sample[i][j] != 'X':
                expected_sum = int(input_sample[i][j])
                # Calculate the sum of neighbors in the output_sample
                actual_sum = sum(
                    [output_sample[i + a][j + b]
                    for a in S for b in S
                    if 0 <= i + a < n and 0 <= j + b < n]
                )
                if actual_sum != expected_sum:
                    return {
                        'result': False,
                        'reason': f'Constraint Violated for cell ({i}, {j}) (0-indexed)'
                    }
    return {
        'result': True,
        'reason': None
    }

def MyVerifier():
    return FillAPixVerifier

if __name__ == '__main__':
    X = 'X'
    input_sample = [
        [X, X, X, X, X, X, X, X, 0, X],
        [X, 8, 8, X, 2, X, 0, X, X, X],
        [5, X, 8, X, X, X, X, X, X, X],
        [X, X, X, X, X, 2, X, X, X, 2],
        [1, X, X, X, 4, 5, 6, X, X, X],
        [X, 0, X, X, X, 7, 9, X, X, 6],
        [X, X, X, 6, X, X, 9, X, X, 6],
        [X, X, 6, 6, 8, 7, 8, 7, X, 5],
        [X, 4, X, 6, 6, 6, X, 6, X, 4],
        [X, X, X, X, X, X, 3, X, X, X]
    ]
    output_sample = [[0, 1, 1, 0, 0, 0, 0, 0, 0, 0], [1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [1, 1, 1, 1, 0, 0, 0, 0, 0, 0], [0, 1, 1, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 1, 1, 1, 1, 1], [0, 0, 0, 1, 1, 1, 1, 1, 1, 1], [0, 0, 0, 1, 0, 1, 1, 1, 1, 1], [0, 1, 1, 1, 1, 1, 1, 1, 1, 1], [0, 1, 0, 1, 1, 1, 0, 1, 0, 1], [0, 0, 1, 0, 0, 0, 1, 0, 1, 0]]
    print(FillAPixVerifier(input_sample, output_sample))
    
