from z3 import *

def FlowShopSolver(input_sample, **kwargs):
    
    num_jobs = input_sample['num_jobs']
    num_machines = input_sample['num_machines']
    T = input_sample['T']
    processing_times = input_sample['processing_times']
    # Create the solver instance
    s = Solver()
    
    # Variable to hold the start times for each job on each machine
    start_times = [[Int(f'start_{j}_{m}') for m in range(num_machines)] for j in range(num_jobs)]
    
    # The makespan is the finish time of the last job on the last machine
    makespan = Int('makespan')
    for m in range(num_machines):
        ## no overlap on same machine
        for j in range(num_jobs):
            s.add(makespan >= start_times[j][m]+ processing_times[m][j]) ### makespan > ending time for each job on each machine
            s.add(start_times[j][m] >= 0)
            
            ## no overlap on each machine
            for k in range(j+1, num_jobs):
                s.add(Or(start_times[j][m]+ processing_times[m][j] <= start_times[k][m], \
                            start_times[k][m]+ processing_times[m][k] <= start_times[j][m]))
    
    for j in range(0, num_jobs):
        for m1 in range(num_machines):
            for m2 in range(m1+1, num_machines):
                ## one job can be done one machine at a time
                s.add(Or(start_times[j][m1] + processing_times[m1][j] <= start_times[j][m2],
                            start_times[j][m2] + processing_times[m2][j] <= start_times[j][m1]))
                
                ## ordering decided by any job (0th WLOG) is preserved
                s.add(Implies(start_times[0][m1] <= start_times[0][m2], start_times[j][m1] <= start_times[j][m2]))
                s.add(Implies(start_times[0][m2] <= start_times[0][m1], start_times[j][m2] <= start_times[j][m1]))
        
    s.add(makespan <= T)

    
    if s.check() == sat:
        model = s.model()
        result = [[model.evaluate(start_times[j][m]) for m in range(num_machines)] for j in range(num_jobs)]
        # for m in range(num_machines):
        #     for j in range(num_jobs):
        #         print(result[j][m], end=' ')
        #     print()
        return ["YES"]
    else:
        return ["NO"]

def MySolver():
    return FlowShopSolver

if __name__ == '__main__':
    # Example data
    input_sample = {
        'num_jobs': 3,
        'num_machines': 2,
        'T': 11,
        'processing_times': [
            [1, 2, 3],
            [4, 5, 1]
        ]
    }

    print(FlowShopSolver(input_sample))

## M1 J1[5-7] J2[9-10] J3[11-14]
## M2 J2[0-5] J1[5-9] J3[9-10]