import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    num_machines, num_jobs, T = tuple(map(int, input_text[0].split()))
    processing_times_text = input_text[1:]
    processing_times = [list(map(int, row.split())) for row in processing_times_text]
    return {
        'num_machines': num_machines,
        'num_jobs': num_jobs,
        'T': T,
        'processing_times': processing_times
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
        if "YES" in output_text[0].upper() and "NO" not in output_text[0].upper():
            return {
                "OUTPUT": "YES",
                "ERROR": None
            }
        
        if "NO" in output_text[0].upper() and "YES" not in output_text[0].upper():
            return {
                "OUTPUT": "NO",
                "ERROR": None
            }
    
        return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    num_machines = input_sample['num_machines']
    num_jobs= input_sample['num_jobs']
    T = input_sample['T']
    processing_times= input_sample['processing_times']
    first_line = f"{num_machines} {num_jobs} {T}"
    processing_times_text = "\n".join(" ".join(map(str, row)) for row in processing_times)
    return "\n".join([first_line, processing_times_text])

def output_to_text_string(output_sample, **kwargs):
    return output_sample