from solver import FlowShopSolver

def FlowShopVerifier(input_sample, output_sample, **kwargs):
    answer = FlowShopSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return FlowShopVerifier

if __name__ == '__main__':
    # Example data
    input_sample = {
        'num_jobs': 3,
        'num_machines': 2,
        'T': 11,
        'processing_times': [
            [1, 2, 3],
            [4, 5, 1]
        ]
    }
    output_sample = "YES"
    print(FlowShopVerifier(input_sample, output_sample)) ## True

    # Example data
    input_sample = {
        'num_jobs': 3,
        'num_machines': 2,
        'T': 11,
        'processing_times': [
            [1, 2, 3],
            [4, 5, 1]
        ]
    }
    output_sample = "NO"
    print(FlowShopVerifier(input_sample, output_sample)) ## False