from z3 import *


def FutoshikiSolver(input_sample, **kwargs):
    input_board = input_sample["input board"]
    lt_edges = input_sample["lt edges"]
    n = len(input_board)
    board = [
        [Int("x_%s_%s" % (i + 1, j + 1)) for j in range(len(input_board))]
        for i in range(len(input_board[0]))
    ]
    s = Solver()

    for i in range(len(input_board)):
        for j in range(len(input_board[0])):
            if input_board[i][j] == 0:
                s.add(And(board[i][j] >= 1, board[i][j] <= n))
            else:
                s.add(
                    board[i][j] == input_board[i][j]
                )  # adding values of known variables

    for i in range(len(input_board)):
        s.add(Distinct(board[i]))  # Row constraint
        s.add(
            Distinct([board[j][i] for j in range(len(input_board[0]))])
        )  # Column constraint

    for lst in lt_edges:
        x, y = lst[0], lst[1]
        s.add(board[x // n][x % n] < board[y // n][y % n])

    if s.check() == sat:
        m = s.model()

    solved_board = [
        [(m.evaluate(board[i][j])).as_long() for j in range(len(input_board))]
        for i in range(len(input_board[0]))
    ]

    return [solved_board]


def MySolver():
    return FutoshikiSolver


if __name__ == "__main__":
    input_sample = {
        "input board": [
            [2, 3, 4, 1, 5],
            [5, 2, 1, 3, 4],
            [0, 1, 0, 5, 3],
            [0, 0, 3, 0, 2],
            [0, 4, 5, 0, 1],
        ],
        "lt edges": [
            [1, 2],
            [20, 21],
            [6, 5],
            [19, 18],
            [8, 13],
            [15, 20],
            [14, 9],
            [11, 10],
            [7, 12],
            [11, 12],
        ],
    }

    print(FutoshikiSolver(input_sample))

    input_sample = {
        "input board": [
            [2, 5, 1, 4, 3],
            [0, 1, 3, 5, 2],
            [0, 4, 0, 3, 5],
            [0, 2, 5, 0, 0],
            [0, 3, 4, 2, 1],
        ],
        "lt edges": [
            [10, 15],
            [4, 3],
            [24, 23],
            [16, 21],
            [12, 11],
            [10, 11],
            [24, 19],
            [21, 22],
            [12, 17],
            [0, 5],
        ],
    }

    print(FutoshikiSolver(input_sample))