import re

SEPERATOR_STRING = "--------"
def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    seperator_idx = input_text.index(SEPERATOR_STRING)
    board_text = input_text[:seperator_idx]
    lt_edges_text = input_text[seperator_idx+1:]
    input_board = [list(map(int, line.strip().split())) for line in board_text]
    lt_edges = [list(map(int, item.split())) for item in lt_edges_text]

    return {
            'input board': input_board,
            'lt edges': lt_edges
        }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                "OUTPUT": None,
                "ERROR": "Output is Empty"
            }
        output_board = [list(map(int, line.strip().split())) for line in output_text]
        for row in output_board:
            if len(row) != num_lines:
                return {
                    "OUTPUT": None,
                    "ERROR": f"Each non empty row in output.txt must have {num_lines} numbers"
                }
        return {
            'OUTPUT': output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    input_board = input_sample['input board']
    lt_edges = input_sample['lt edges']
    input_board_string = "\n".join(" ".join(map(str, row)) for row in input_board)

    lt_edges_string = "\n".join(" ".join(map(str, row)) for row in lt_edges)
    return "\n".join((input_board_string, lt_edges_string))

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)