import numpy as np


def FutoshikiVerifier(input_sample, output_board, **kwargs):
    input_board = input_sample["input board"]
    lt_edges = input_sample["lt edges"]
    input_board = np.array(input_board)
    output_board = np.array(output_board)

    num_rows, num_cols = len(output_board), len(output_board[0])
    assert num_rows == num_cols
    N = num_rows

    if (input_board.shape) != (output_board.shape):
        return {
            "result": False,
            "reason": "Input and Output Boards do not have the same shape",
        }

    for i in range(len(input_board)):
        for j in range(len(input_board[0])):
            if str(input_board[i][j]) != "0":
                if str(input_board[i][j]) != str(output_board[i][j]):
                    return {
                        "result": False,
                        "reason": f"Original numbers on Non-Empty cells in input have been removed in the output. For eg Cell ({i}, {j}) (0-indexed)",
                    }

    for idx, row in enumerate(output_board):
        if len(row) != len(set(row)):
            return {
                "result": False,
                "reason": f"Unique elements in row constraint violated for Row: {idx} (0-indexed) of output ",
            }

    # Check columns

    for j in range(num_cols):
        column = [output_board[i][j] for i in range(num_rows)]
        if len(column) != len(set(column)):
            return {
                "result": False,
                "reason": f"Unique elements in column constraint violated for Column: {j} (0-indexed) of output",
            }
    output_flattened = output_board.flatten()
    for lst in lt_edges:
        if output_flattened[lst[0]] < output_flattened[lst[1]]:
            continue
        else:
            return {
                "result": False,
                "reason": f"Inequality constraints have been violated for the cells ({lst[0]}, {lst[1]})",
            }

    ### check all elements are from 1 to N
    for i in range(num_rows):
        for j in range(num_cols):
            try:
                element = int(output_board[i][j])
                if element <= 0 or element > N:
                    return {
                        "result": False,
                        "reason": f"Elements in Output board should be from 1 to {N}. Violated for Cell ({i}, {j}) (0-indexed)",
                    }
            except Exception as e:
                return {
                    "result": False,
                    "reason": f"Output Board should have Integer Elements. Violated for Cell ({i}, {j}) (0-indexed)",
                }

    return {"result": True, "reason": None}


def MyVerifier():
    return FutoshikiVerifier


if __name__ == "__main__":
    input_sample = {
        "input board": [
            [2, 3, 4, 1, 5],
            [5, 2, 1, 3, 4],
            [0, 1, 0, 5, 3],
            [0, 0, 3, 0, 2],
            [0, 4, 5, 0, 1],
        ],
        "lt edges": [
            [1, 2],
            [20, 21],
            [6, 5],
            [19, 18],
            [8, 13],
            [15, 20],
            [14, 9],
            [11, 10],
            [7, 12],
            [11, 12],
        ],
    }
    output_board = [
        [2, 3, 4, 1, 5],
        [5, 2, 1, 3, 4],
        [4, 1, 2, 5, 3],
        [1, 5, 3, 4, 2],
        [3, 4, 5, 2, 1],
    ]

    print(FutoshikiVerifier(input_sample, output_board))