from z3 import *

def GraphColoringSolver(input_sample, **kwargs):
    N = input_sample['number_of_nodes']
    edges = input_sample['edges']
    K = input_sample['k']
    
    solver = Solver()
    ### these variables represent the colour of the nodes, ith variable is the color of the ith node
    variables = [Int(f"x_{i}") for i in range(N)]
    
    ### initial constraints
    for i in range(N):
        solver.add(variables[i] >= 0, variables[i] < K)
    
    ### two nodes having an edge must have a different color
    for i in range(N):
        for j in range(i+1, N):
            if (i, j) in edges or (j, i) in edges:
                solver.add(variables[i] != variables[j])

    if solver.check() == sat:
        return ["YES"] ### returns one of multiple solutions
    else:
        return ["NO"]

def MySolver():
    return GraphColoringSolver

if __name__ == "__main__":
    
    input_sample = {
        'number_of_nodes': 3,
        'edges' : [(0,1), (1,2), (0,2)],
        'k': 1
    } ## NO
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 3,
        'edges' : [(0,1), (1,2), (0,2)],
        'k': 2
    } ## NO
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 3,
        'edges' : [(0,1), (1,2), (0,2)],
        'k': 3
    } ## NO
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 3,
        'edges' : [(0,1), (1,2)],
        'k': 2
    } ## YES
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 3,
        'edges' : [(0,1), (1,2)],
        'k': 1
    } ## NO
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (1,2), (2, 3), (3, 4), (4, 0)],
        'k': 3
    } ## YES
    print(GraphColoringSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (1,2), (2, 3), (3, 4), (4, 0)],
        'k': 2
    } ## NO
    print(GraphColoringSolver(input_sample=input_sample))