from solver import GraphColoringSolver


def GraphColoringVerifier(input_sample, output_sample, **kwargs):
    answer = GraphColoringSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The generated answer is not correct"
    }

def MyVerifier():
    return GraphColoringVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (1,2), (2, 3), (3, 4), (4, 0)],
        'k': 2
    } ## NO
    output_sample = "YES"
    print(GraphColoringVerifier(input_sample=input_sample, output_sample=output_sample)) ## False

    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (1,2), (2, 3), (3, 4), (4, 0)],
        'k': 2
    } ## NO
    output_sample = "NO"
    print(GraphColoringVerifier(input_sample=input_sample, output_sample=output_sample)) ## True