from solver import HamiltonianCycleSolver

def HamiltonianCycleVerifier(input_sample, output_sample, **kwargs):
    answer = HamiltonianCycleSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The generated answer is not correct"
    }

def MyVerifier():
    return HamiltonianCycleVerifier

if __name__ == '__main__':
    
    input_sample = {
        'number_of_nodes': 5,
        'edges': [(0, 1), (0, 2), (0, 3), (0, 4), (1, 2), (3, 4)]
    }
    output_sample = "YES"
    print(HamiltonianCycleVerifier(input_sample=input_sample, output_sample=output_sample)) ## False

    input_sample = {
        'number_of_nodes': 5,
        'edges': [(0, 1), (0, 2), (0, 3), (0, 4), (1, 2), (3, 4)]
    }
    output_sample = "NO"
    print(HamiltonianCycleVerifier(input_sample=input_sample, output_sample=output_sample)) ## True