from solver import HamiltonianPathSolver

def HamiltonianPathVerifier(input_sample, output_sample, **kwargs):
    answer = HamiltonianPathSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return HamiltonianPathVerifier

if __name__ == '__main__':
    
    input_sample = {
        'number_of_nodes': 6,
        'edges': [(0, 1), (1, 2), (2, 3), (2, 4), (4, 5)]
    }
    output_sample = "YES"
    print(HamiltonianPathVerifier(input_sample=input_sample, output_sample=output_sample)) ## False

    input_sample = {
        'number_of_nodes': 6,
        'edges': [(0, 1), (1, 2), (2, 3), (2, 4), (4, 5)]
    }
    output_sample = "NO"
    print(HamiltonianPathVerifier(input_sample=input_sample, output_sample=output_sample)) ## True