import numpy as np
import math


def check_array(arr):
    M, N = arr.shape
    expected_sum = M * N
    flattened_arr = arr.flatten()
    
    # Check if array contains integers from 1 to M*N
    if np.min(flattened_arr) == 1 and np.max(flattened_arr) == M * N:
        # Check if all numbers are unique
        if len(np.unique(flattened_arr)) == expected_sum:
            return True
    return False

def find_index(arr, element):
    result = np.where(arr == element)
    return tuple(zip(result[0], result[1]))[0]

def are_neighbors(index1, index2):
    # Extract row and column for each index
    row1, col1 = index1
    row2, col2 = index2
    
    # Check the difference in rows and columns
    row_diff = abs(row1 - row2)
    col_diff = abs(col1 - col2)
    
    # They are neighbors if both differences are 0 or 1 and not both zero
    return (row_diff <= 1 and col_diff <= 1) and not (row_diff == 0 and col_diff == 0)



def HidatoVerifier(input_board, output_board, **kwargs):
    input_board = np.array(input_board)
    output_board = np.array(output_board)

    if (input_board.shape) != (output_board.shape):
        return {
            "result": False,
            "reason": "Input and Output Boards do not have the same shape",
        }
    for i in range(len(input_board)):
        for j in range(len(input_board[0])):
            if str(input_board[i][j]) != "0":
                if str(input_board[i][j]) != str(output_board[i][j]):
                    return {
                        "result": False,
                        "reason": f"Original numbers on Non-Empty cells have been removed in output. Eg. Cell ({i+1}, {j+1}) (1-indexed)",
                    }
    
    if not check_array(output_board):
         return {
             'result': False,
             'reason': f"Each element from 1-{input_board.shape[0]*input_board.shape[1]} must be present once in the output"
         }
         
        
    for i in range(2, input_board.shape[0] * input_board.shape[1]+1):
        pred_idx = find_index(output_board, i-1)
        curr_idx = find_index(output_board, i)
        if not are_neighbors(pred_idx, curr_idx):
            return {
                'result': False,
                'reason': 'Successive numbers must be neighboours either horizontally or vertically or diagonally'
            }
        
    return {"result": True, "reason": None}


def MyVerifier():
    return HidatoVerifier


if __name__ == "__main__":
    input_board = [[6, 0, 9],
                    [0, 2, 8],
                    [1, 0, 0]]

    output_board = [[6, 7, 9],
                    [5, 2, 8],
                    [1, 4, 3]]

    print(HidatoVerifier(input_board, output_board))
